//Program to find out transient stability analysis of multi machine at the end of the iteration //
//This program requires user input. A sample problem with user input and output is available in the result file//
//Scilab Version 5.5.2 ; OS:Windows
//program for transient stability analysis of multi machine//
clc;
clc;
clear;
f=input('enter the frequency:');
bv=input('enter the base value in MVA:');
v=input('enter the value of bus voltage in p.u:');
e=input('enter the value of transient reactance voltage in pu:');
ld=input('enter the total load:');
x1=input('enter the prefault reactance in p.u:');
x2=input('enter the post fault reactance value:');
x3=input('enter during the fault reactance value:');
delt=input('enter the time interval in seconds:');
H=input('enter the inertia constant:');
pe1=ld/bv;

pe2=0;
delnot=asin((pe1*x1)/(e*v));

omeganot=2*3.14*f;


ddel=omeganot-(2*3.14*f);

ddelomega=(((3.14*f)*(pe1-pe2))/H);

//end of first step at t=0.05sec
del1=(delnot+(ddel*delt));//predicted values

delomega1=ddel+(ddelomega*delt);

//derivation at the end of t=0.05sec
ddel1=ddel+(ddelomega*delt);

ddelomega=(((3.14*f)*(pe1-pe2))/H);

delc1=delnot+((delt/2)*(ddel+ddel1));

delomegac1=ddel+((delt/2)*(ddelomega+ddelomega));

ddelc1=ddel+((delt/2)*(ddelomega+ddelomega));

ddelomegac=(((3.14*f)*(pe1-pe2))/H);

delp2=delc1+ddelc1*delt;

delomegap2=(delomegac1+(ddelomega*delt));

ddelomegap=(((3.14*f)*(pe1-pe2))/H);


delc2=delc1+(delt/2*(ddelc1+delomegap2));

delomegac=(delomegac1+(ddelomega*delt));

ddelc2=(delomegac1+(ddelomega*delt));

ddelomegac2=(((3.14*f)*(pe1-pe2))/H);

delp3=delc2+delomegac*delt;

delomega3=delomegac+ddelomegac2*delt;

//derivation at the end of t=0.15sec
disp('The final values at the end of t=0.15 sec are displayed below')
ddelp3=delomegac+ddelomegac2*delt;
disp(ddelp3,'ddelp3=');
ddelomega3=(((3.14*f)*(pe1-pe2))/H);
disp(ddelomega3,'ddelomega3=');
disp('corrected values');
delc3=delc2+((delt/2)*(delomegac+delomega3));
disp(delc3,'delc3=');
delomegac3=delomegac+((delt/2)*(ddelomega3+ddelomega3));
disp(delomegac3,'delomegac3=');

//SAMPLE INPUT:
//enter the frequency:50
//enter the base value in MVA:500
//enter the value of bus voltage in p.u:1
//enter the value of transient reactance voltage in pu:450/400
//enter the total load:460
//enter the prefault reactance in p.u:0.5
//enter the post fault reactance value:0.75
//enter during the fault reactance value:1
//enter the time interval in seconds:0.05
//enter the inertia constant:2.5
 
 
 //OUTPUT
// The final values at the end of t=0.15 sec are displayed below   
 
// ddelp3=   
 
//    8.6664  
 
// ddelomega3=   
 
//    57.776  
 
// corrected values   
 
// delc3=   
 
//    1.0712162  
 
// delomegac3=   
 
//    8.6664  
 
